/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DatagenLootTableManager
extends LootTableManager {
    private static final Gson GSON = LootSerializers.func_237388_c_().create();
    private final ExistingFileHelper existingFileHelper;
    private final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();

    public DatagenLootTableManager(@NotNull ExistingFileHelper existingFileHelper) {
        super(new LootPredicateManager());
        this.existingFileHelper = existingFileHelper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public LootTable func_186521_a(@NotNull ResourceLocation location) {
        LootTable table = this.tables.get(location);
        if (table != null) {
            return table;
        }
        try {
            IResource resource = this.existingFileHelper.getResource(this.getPreparedPath(location), ResourcePackType.SERVER_DATA);
            try (InputStream inputstream = resource.func_199027_b();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                JsonObject jsonobject = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                LootTable loottable = ForgeHooks.loadLootTable((Gson)GSON, (ResourceLocation)location, (JsonElement)jsonobject, (boolean)false, (LootTableManager)this);
                if (loottable == null) return LootTable.field_186464_a;
                this.tables.put(location, loottable);
                LootTable lootTable = loottable;
                return lootTable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return LootTable.field_186464_a;
    }
}

